clear

figure('Position', [200 80 1000 420])

% p = uipanel('Position',[.1 .0 .9 .9],'BorderType', 'none');
t = tiledlayout(2,5);
t.TileSpacing = 'none';
t.Padding = 'none';
title(t, 'Crank Phasing [deg]', 'FontWeight', 'Bold', 'FontSize', 12)
ylabel(t, {'Operating Point';'';'';''}, 'FontWeight', 'Bold', 'FontSize', 12)

Phase = 0:5:20;
ExPortH = 0.075:0.0125:0.225;
InPortH = 0.05:0.0125:0.2;

load('RE_Data.mat')

BSFC_Matrices(:,1) = BSFC_1500;
BSFC_Matrices(:,2) = BSFC_3000;

% FigureLabels = 'a':'z';

for j = 1:2
    BSFC_Mat(:,:,:) = reshape(BSFC_Matrices(:,j),13,13,5);
    for i = 1:5
        nexttile(t)
        [c,h] = contourf(ExPortH,InPortH,BSFC_Mat(:,:,i), (200:5:300), 'LineColor', [0.2 0.2 0.2]);
        clabel(c,h,'LabelSpacing',1000,'FontSize', 9);
        colormap(gca, flipud(turbo))
        caxis([200 300])
        set(gca, 'FontSize', 10)
        
        if j == 1
            str = num2str(Phase(i));
            title({str;''}, 'FontWeight', 'bold', 'FontSize', 12)
            if i == 1
                cb = colorbar;
                cb.Layout.Tile = 'east';
                cb.Ticks = 200:20:300;
                cb.FontSize = 10;
                cb.Title.FontSize = 12;
                cb.Title.String = {'BSFC';'g/kWh'};
            end
        end
        
        if i == 1
            yticks(0:0.05:0.3)
            ytickformat('%.2f')
        else
            set(gca,'Yticklabel',[])
        end
        
        if j == 2 && i == 1
            ylabel('                                           Intake Port Height Ratio', 'FontSize', 10)
        end
        
        if j == 2
            xticks(0:0.05:0.3)
            xtickformat('%.2f')
        else
            set(gca,'Xticklabel',[])
        end
        
%         str = (sprintf('(%c)',FigureLabels(((j-1)*5)+i)));
        
        if j == 2 && i == 3
            xlabel('Exhaust Port Height Ratio', 'FontSize', 10)
        end

        axis('square')
        
        hold on
        [m,index] = min(BSFC_Mat(:,:,i));
        [m2,index2] = min(m);
        x = ExPortH(index2);
        y = InPortH(index(index2));
        plot(x,y,'k+','MarkerSize', 15);
        text(x+0.004,y-0.008,num2str(m2,'%.0f'), 'Color', 'k', 'FontWeight', 'bold', 'FontSize', 10);
        hold off
    end
end

annotation('textbox', [0.03, 0.69, 0, 0], 'string', 'D', 'FontWeight', 'bold', 'FontSize', 15)
annotation('textbox', [0.03, 0.31, 0, 0], 'string', 'E', 'FontWeight', 'bold', 'FontSize', 15)

% annotation('textbox', [0.01, 0.98, 0, 0], 'string', '30kW', 'FontWeight', 'bold', 'FontSize', 15)
